import os
import shutil

def count_images(directory):
    extensions = ('.jpg', '.jpeg', '.png', '.bmp', '.gif')
    folder_counts = {}
    total_count = 0
    for root, dirs, files in os.walk(directory):
        count = 0
        for file in files:
            if file.lower().endswith(extensions):
                count += 1
        if count > 0:
            folder_counts[root] = count
            total_count += count

    return folder_counts, total_count

def copy_images_to_one_folder(source_directory, target_directory):
    if not os.path.exists(target_directory):
        os.makedirs(target_directory)
    extensions = ('.jpg', '.jpeg', '.png', '.bmp', '.gif')
    for root, dirs, files in os.walk(source_directory):
        for file in files:
            if file.lower().endswith(extensions):
                source_path = os.path.join(root, file)
                target_path = os.path.join(target_directory, file)
                if os.path.exists(target_path):
                    base, extension = os.path.splitext(file)
                    count = 1
                    new_file = f"{base}_{count}{extension}"
                    target_path = os.path.join(target_directory, new_file)
                    while os.path.exists(target_path):
                        count += 1
                        new_file = f"{base}_{count}{extension}"
                        target_path = os.path.join(target_directory, new_file)
                shutil.copy2(source_path, target_path)

source_directory = '../MNIST/raw/TRAIN/'
target_directory = 'data/train'

copy_images_to_one_folder(source_directory, target_directory)

folder_counts, total_count = count_images(source_directory)
print("Number of images in each folder:")
for folder, count in folder_counts.items():
    print(f"{folder}: {count}")
print(f"Total number of images: {total_count}")